/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplication;

import datasource.DataSource;
import datasource.FileDataSource;
import datasource.DataSourceFactory;
import datasource.InMemoryDataSource;
import datasource.SingletonDataSource;
import java.util.List;
import products.Colour;
import products.Item;
import products.Product;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPatterns {

    public static void main(String[] args) {
       
        //Using Implementation
//        DataSource ds = new FileDataSource();

        //Using Factory
//        DataSourceFactory dsf = new DataSourceFactory();
        //Getting datasource from factory
//        DataSource ds = dsf.getDataSource();
//        ds.retrieveList("Demo").printList();

        //Getting a specific implementation from the factory
//        DataSource ds = dsf.getDataSourceFrom("File");
//        ds.retrieveList("Demo").printList();
        
        //Singleton Pattern
//        DataSource ds1 = new InMemoryDataSource();
//        DataSource ds2 = new InMemoryDataSource();
//        ds1.saveList("Empty List", new PriceList());
//        ds1.getListNames();
//        ds2.getListNames();
        //Using the singleton
//        DataSource ds1 = SingletonDataSource.getInstance();
//        DataSource ds2 = SingletonDataSource.getInstance();
//        ds1.saveList("Empty List", new PriceList());
//        ds1.getListNames();
//        ds2.getListNames();
        
        //Builder Pattern
        //Basic build
//        Product p = new Product.ProductBuilder("New Product").build();
//        p.printProduct();
        //Full build
        Product p = new Product.ProductBuilder("New Product")
                           .atPrice(3.45)
                           .atDescription("A brand new product.")
                           .atBrand("Gregco")
                           .atColour(Colour.GREEN)
                           .build();
        p.printProduct();
        System.out.println("Other properties: \n"
                           +"Brand - "+p.getBrand()+"\n"
                           +"Colour - "+p.getColour());
    }
}
